;Juego map editor - deeph copyleft 2012

EnableExplicit
XIncludeFile "main.pbi"
Init()
Main()
End

Procedure Main()
  If CountProgramParameters() > 0
    Open(ProgramParameter())
    If isset > 0
      InitWorkArea()
      HandleMap()
    EndIf
  EndIf
  Protected event.l, quit.l = 0, ans.l, file.s, map_path.s = "map\", filterM.s = "Map (*.map)|*.map", mapx_path.s = "map\", filterMx.s = "z80 Assembler include (*.inc)|*.inc", x.l, y.l, ok.l = 0
  Repeat
    Repeat
      event = WindowEvent()
      If EventWindow() = #Window
        Select event
          Case #PB_Event_Menu
            drawing_allowed = 0
            Select EventMenu()
              Case #New
                If isset = 1
                  ans = MessageRequester("Error", "Current map isn't saved, do it now ?", #PB_MessageRequester_YesNoCancel)
                  If ans <> #PB_MessageRequester_Cancel
                    If ans = #PB_MessageRequester_Yes
                      If map_\file <> ""
                        Save(map_\file)
                      Else
                        SaveRequester(SaveFileRequester("Save as...", map_path, filterM, 0))
                      EndIf
                    EndIf
                    New()
                  EndIf
                Else
                  New()
                EndIf
                If isset > 0
                  InitWorkArea()
                  HandleMap()
                EndIf
              Case #Open
                file = OpenFileRequester("Open...", map_path, filterM, 0)
                If file
                  If FileSize(file) > 0
                    If isset = 1
                      If MessageRequester("Error", "Current map isn't saved. Do it now ?", #PB_MessageRequester_YesNo) = #PB_MessageRequester_Yes
                        SaveRequester(SaveFileRequester("Save as...", map_path, filterM, 0))
                      EndIf
                    EndIf
                    Open(file)
                    If isset > 0
                      Close()
                      isset = 2
                      InitWorkArea()
                      HandleMap()
                    EndIf
                  Else
                    MessageRequester("FileSize() error", "Unable to open file.")
                  EndIf
                EndIf
              Case #Save
                If map_\file <> ""
                  Save(map_\file)
                Else
                  SaveRequester(SaveFileRequester("Save as...", map_path, filterM, 0))
                EndIf
              Case #Save_as
                SaveRequester(SaveFileRequester("Save as...", map_path, filterM, 0))
              Case #Export
                ExportRequester(SaveFileRequester("Export as...", mapx_path, filterMx, 0))
              Case #Zoom1
                zoom = 1
                SetToolBarButtonState(#ToolBar, #Zoom1, 1)
                SetToolBarButtonState(#ToolBar, #Zoom2, 0)
                SetGadgetAttribute(#MapScrollArea, #PB_ScrollArea_InnerWidth, map_\w*#TILE_WIDTH*zoom)
                SetGadgetAttribute(#MapScrollArea, #PB_ScrollArea_InnerHeight, map_\h*#TILE_HEIGHT*zoom)
                ResizeGadget(#MapGadget, #PB_Ignore, #PB_Ignore, map_\w*#TILE_WIDTH*zoom, map_\h*#TILE_HEIGHT*zoom)
                RefreshMap()
              Case #Zoom2
                zoom = 2
                SetToolBarButtonState(#ToolBar, #Zoom1, 0)
                SetToolBarButtonState(#ToolBar, #Zoom2, 1)
                SetGadgetAttribute(#MapScrollArea, #PB_ScrollArea_InnerWidth, map_\w*#TILE_WIDTH*zoom)
                SetGadgetAttribute(#MapScrollArea, #PB_ScrollArea_InnerHeight, map_\h*#TILE_HEIGHT*zoom)
                ResizeGadget(#MapGadget, #PB_Ignore, #PB_Ignore, map_\w*#TILE_WIDTH*zoom, map_\h*#TILE_HEIGHT*zoom)
                RefreshMap()
              Case #Close
                If isset = 1
                  If MessageRequester("Error", "Current map isn't saved. Do it now ?", #PB_MessageRequester_YesNo) = #PB_MessageRequester_Yes
                    If map_\file <> ""
                      Save(map_\file)
                    Else
                      SaveRequester(SaveFileRequester("Save as...", map_path, filterM, 0))
                    EndIf
                  EndIf
                EndIf
                Close()
                isset = 0
              Case #Quit
                quit = 1
              Case #Grid
                grid+1
                If grid = 2
                  grid = 0
                EndIf
                SetMenuItemState(#Menu, #Grid, grid)
                RefreshMap()
              Case #Screenshot
                Screenshot()
              Case #Tiles_editor
                Tiles_editor()
              Case #Masks_editor
                Masks_editor()
              Case #About
                MessageRequester("About...", "Juego map editor - deeph copyleft 2012")
              Case #Pen
                SetToolBarButtonState(#ToolBar, #Pen, 1)
                SetToolBarButtonState(#ToolBar, #Square, 0)
                SetToolBarButtonState(#ToolBar, #Fill, 0)
                tool = 1
              Case #Square
                SetToolBarButtonState(#ToolBar, #Pen, 0)
                SetToolBarButtonState(#ToolBar, #Square, 1)
                SetToolBarButtonState(#ToolBar, #Fill, 0)
                tool = 2
              Case #Fill
                SetToolBarButtonState(#ToolBar, #Pen, 0)
                SetToolBarButtonState(#ToolBar, #Square, 0)
                SetToolBarButtonState(#ToolBar, #Fill, 1)
                tool = 3
            EndSelect
          Case #PB_Event_Gadget
            Select EventGadget()
              Case #MapGadget
                Select EventType()
                  Case #PB_EventType_MouseEnter
                    drawing_allowed = 1
                  Case #PB_EventType_MouseLeave
                    drawing_allowed = 0
                EndSelect
                MapEvent(event)
              Case #BrushesListIcon
                If GetGadgetState(#BrushesListIcon) <> -1
                  If GetGadgetState(#BrushesListIcon) <> 0
                    DisableGadget(#UpButton2, 0)
                  Else
                    DisableGadget(#UpButton2, 1)
                  EndIf
                  If GetGadgetState(#BrushesListIcon) <> CountGadgetItems(#BrushesListIcon)-1
                    DisableGadget(#DownButton2, 0)
                  Else
                    DisableGadget(#DownButton2, 1)
                  EndIf
                  tiles_cursor\id = GetGadgetState(#BrushesListIcon)
                  DisableGadget(#EditButton, 0)
                  DisableGadget(#RemoveButton2, 0)
                Else
                  DisableGadget(#UpButton2, 1)
                  DisableGadget(#DownButton2, 1)
                  DisableGadget(#EditButton, 1)
                  DisableGadget(#RemoveButton2, 1)
                EndIf
              Case #UpButton2
                ans = GetGadgetState(#BrushesListIcon)-1
                ForEach brushes()
                  FreeImage(Val(MapKey(brushes())))
                Next
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\tile, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\tile
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\animation, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\animation
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\offset, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\offset
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\passable, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\passable
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\height, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\height
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\masked, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\masked
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\mask, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\mask
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\collision, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\collision
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\interaction, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\interaction
                ClearGadgetItems(#BrushesListIcon)
                RefreshBrushes()
                SaveBrushes()
                SetGadgetState(#BrushesListIcon, ans)
              Case #DownButton2
                ans = GetGadgetState(#BrushesListIcon)+1
                ForEach brushes()
                  FreeImage(Val(MapKey(brushes())))
                Next
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\tile, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\tile
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\animation, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\animation
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\offset, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\offset
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\passable, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\passable
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\height, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\height
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\masked, brushes(Str(GetGadgetState(#BrushesListIcon)-1))\masked
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\mask, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\mask
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\collision, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\collision
                Swap brushes(Str(GetGadgetState(#BrushesListIcon)))\interaction, brushes(Str(GetGadgetState(#BrushesListIcon)+1))\interaction
                ClearGadgetItems(#BrushesListIcon)
                RefreshBrushes()
                SaveBrushes()
                SetGadgetState(#BrushesListIcon, -1)
              Case #AddButton2
                New_brush()
              Case #RemoveButton2
                DeleteMapElement(brushes(), Str(GetGadgetState(#BrushesListIcon)))
                RemoveGadgetItem(#BrushesListIcon, GetGadgetState(#BrushesListIcon))
                ClearGadgetItems(#BrushesListIcon)
                RefreshBrushes()
                SaveBrushes()
              Case #EditButton
                Edit_brush(GetGadgetState(#BrushesListIcon))
            EndSelect
          Case #PB_Event_SizeWindow
            drawing_allowed = 0
            If isset > 0
              ResizeGadget(#BrushesListIcon, #BrushesListIcon_x, #BrushesListIcon_y, #BrushesListIcon_w, WindowHeight(#Window)-#BrushesListIcon_y-44-24*2)
              ResizeGadget(#UpButton2, #UpButton2_x, #BrushesListIcon_y+GadgetHeight(#BrushesListIcon), #UpButton2_w, #UpButton2_h)
              ResizeGadget(#DownButton2, #DownButton2_x, GadgetY(#UpButton2), #DownButton2_w, #DownButton2_h)
              ResizeGadget(#AddButton2, #AddButton2_x, GadgetY(#UpButton2)+#AddButton2_h, #AddButton2_w, #AddButton2_h)
              ResizeGadget(#RemoveButton2, #RemoveButton2_x, GadgetY(#AddButton2), #RemoveButton2_w, #RemoveButton2_h)
              ResizeGadget(#EditButton, #EditButton_x, GadgetY(#RemoveButton2), #EditButton_w, #EditButton_h)
              ResizeGadget(#MapScrollArea, #MapScrollArea_x, #MapScrollArea_y, WindowWidth(#Window)-#MapScrollArea_x-1, WindowHeight(#Window)-#MapScrollArea_y-44)
            EndIf
          Case #PB_Event_CloseWindow
            quit = 1
          Case #PB_Event_ActivateWindow
            drawing_allowed = 0
        EndSelect
        If isset = 1
          DisableMenuItem(#Menu, #Save, 0)
          DisableToolBarButton(#ToolBar, #Save, 0)
        ElseIf isset = 2
          DisableMenuItem(#Menu, #Save, 1)
          DisableToolBarButton(#ToolBar, #Save, 1)
        EndIf
      EndIf
    Until event = 0
    Delay(10)
  Until quit
  If isset = 1
    If isset = 1
      If MessageRequester("Error", "Current map isn't saved. Do it now ?", #PB_MessageRequester_YesNo) = #PB_MessageRequester_Yes
        If map_\file <> ""
          Save(map_\file)
        Else
          SaveRequester(SaveFileRequester("Save as...", map_path, filterM, 0))
        EndIf
      EndIf
    EndIf
  EndIf
EndProcedure

Procedure Close()
  DisableMenuItem(#Menu, #Save, 1)
  DisableMenuItem(#Menu, #Save_as, 1)
  DisableMenuItem(#Menu, #Export, 1)
  DisableMenuItem(#Menu, #Close, 1)
  DisableMenuItem(#Menu, #Grid, 1)
  DisableMenuItem(#Menu, #Screenshot, 1)
  DisableToolBarButton(#ToolBar, #Save, 1)
  DisableToolBarButton(#ToolBar, #Pen, 1)
  DisableToolBarButton(#ToolBar, #Square, 1)
  DisableToolBarButton(#ToolBar, #Fill, 1)
  DisableToolBarButton(#ToolBar, #Zoom1, 1)
  DisableToolBarButton(#ToolBar, #Zoom2, 1)
  FreeGadget(#BrushesListIcon)
  FreeGadget(#UpButton2)
  FreeGadget(#DownButton2)
  FreeGadget(#AddButton2)
  FreeGadget(#RemoveButton2)
  FreeGadget(#EditButton)
  FreeGadget(#MapScrollArea)
  FreeGadget(#MapGadget)
  isset = 0
EndProcedure
; IDE Options = PureBasic 4.60 (Windows - x86)
; CursorPosition = 270
; FirstLine = 249
; Folding = -
; EnableXP
; EnableUser
; UseIcon = icons\icon.ico
; Executable = ..\Pokmon map editor.exe
; CurrentDirectory = ..\
; EnablePurifier
; IncludeVersionInfo
; VersionField0 = 0.0.1.1
; VersionField1 = 0.0.1.1
; VersionField3 = Map editor
; VersionField6 = Map editor
; VersionField9 = Copyleft
; VersionField14 = http://deeph.servhome.org
; VersionField16 = VFT_APP
; VersionField17 = 040c French (Standard)